﻿Option Explicit On
Imports Inventor
Sub Main
	Dim oDrawing As Document = ThisDoc.Document

	Dim nameList As New List(Of String)
	nameList.Add("my_BalloonStyles")
	nameList.Add("my_DimensionStyles")
	nameList.Add("DimensionColor")
	nameList.Add("BalloonColor")
	nameList.Add("TextColor")
	Dim oParam As UserParameter
	For Each item In nameList
		oParam = FindParamUsingName(oDrawing, item)
		If oParam Is Nothing Then
			PutParameter(oDrawing, item, "", "text")
		End If
	Next
End Sub

Sub PutParameter(oDoc As Document, sName As String, vValue As Object, sType As String, Optional sLengthUnits As String = "cm")
	Logger.Trace(sName)
	Dim oParam As Inventor.Parameter
	oParam = FindParamUsingName(oDoc, sName)
	Dim oParams As Inventor.Parameters
	Select Case oDoc.DocumentType
		Case DocumentTypeEnum.kAssemblyDocumentObject, DocumentTypeEnum.kPartDocumentObject
			oParams = oDoc.ComponentDefinition.Parameters
		Case DocumentTypeEnum.kDrawingDocumentObject
			oParams = oDoc.Parameters
	End Select

	If oParam Is Nothing Then
		Select Case sType.ToLower()
			Case "length" : oParam = oParams.UserParameters.AddByValue(sName, vValue, sLengthUnits)
			Case "text" : oParam = oParams.UserParameters.AddByValue(sName, vValue, UnitsTypeEnum.kTextUnits)
			Case "bool" : oParam = oParams.UserParameters.AddByValue(sName, vValue, UnitsTypeEnum.kBooleanUnits)
		End Select
	End If
End Sub

Function FindParamUsingName(oDoc As Document, sName As String) As Inventor.Parameter
	Dim oParam As Inventor.Parameter
	Dim oParams As Inventor.Parameters

	Select Case oDoc.documenttype
		Case DocumentTypeEnum.kAssemblyDocumentObject, DocumentTypeEnum.kPartDocumentObject
			oParams = oDoc.ComponentDefinition.Parameters
		Case DocumentTypeEnum.kDrawingDocumentObject
			oParams = oDoc.Parameters
	End Select

	Dim bFound = True
	For Each oParam In oParams
		If oParam.Name.ToLower.Equals(sName.ToLower())
			bFound = True
			Return oParam
		End If
	Next
	Return Nothing
End Function
