﻿
Sub Main
	Dim DrawingDoc As DrawingDocument = ThisDoc.Document 
	MultiValue.SetValueOptions(True)
	MultiValue.SetList("DimensionColor", "Black", "Red", "Green", "Blue")
	MultiValue.SetList("BalloonColor", "Black","Red", "Green", "Blue")
	MultiValue.SetList("TextColor",  "Black", "Red", "Green", "Blue")

	Dim oDColor = GetColor(Parameter("DimensionColor"))
	Dim oBColor = GetColor(Parameter("BalloonColor"))
	Dim oTColor = GetColor(Parameter("TextColor"))
	
	Dim oSM As DrawingStylesManager
	oSM = DrawingDoc.StylesManager
	Dim sDS As New ArrayList
	Dim oDS As DimensionStyle
	For Each oDS In oSM.DimensionStyles
		If Not oDS.StyleLocation = StyleLocationEnum.kLibraryStyleLocation Then 
			oDS.Color = oDColor
			oDS.TextStyle.Color = oTColor
			sDS.Add(oDS.Name)
		End If 		
	Next 
	MultiValue.List("my_DimensionStyles") = sDS

	Dim sBS As New ArrayList
	Dim oBS As BalloonStyle 
	For Each oBS In oSM.BalloonStyles 
		If Not oBS.StyleLocation = StyleLocationEnum.kLibraryStyleLocation Then 
			oBS.LeaderStyle.Color = oBColor
			oBS.TextStyle.Color = oTColor
			sBS.Add(oBS.Name)
		End If
	Next 
	MultiValue.List("my_BalloonStyles") = sBS
End Sub 

Function GetColor(sColor As String) As Inventor.Color
	Dim oColor As Inventor.Color
	Select Case sColor.ToLower()
	Case "red"
		oColor = ThisApplication.TransientObjects.CreateColor(255, 0, 0)
	Case "green"
		oColor = ThisApplication.TransientObjects.CreateColor(0, 255, 0)
	Case "blue"
		oColor = ThisApplication.TransientObjects.CreateColor(0, 0, 255)
	Case "black"
		oColor = ThisApplication.TransientObjects.CreateColor(0, 0, 0)
	End Select
	Return oColor
End Function 
